

CREATE TABLE `calificacion_calificaciones` (
  `id` int(5) NOT NULL COMMENT 'Id',
  `calificacion` int(5) NOT NULL COMMENT 'Calificación Id',
  `saber` varchar(255) DEFAULT NULL COMMENT 'Saber',
  `ser` varchar(255) DEFAULT NULL COMMENT 'Ser',
  `nivelacion` varchar(255) DEFAULT NULL COMMENT 'Nivelación',
  `docente` int(3) NOT NULL COMMENT 'Docente',
  `estudiante` int(3) NOT NULL COMMENT 'Estudiante',
  `grupo` int(3) NOT NULL COMMENT 'Grupo',
  `asignatura` int(3) NOT NULL COMMENT 'Asignatura',
  `periodo` int(1) NOT NULL COMMENT 'Periodo',
  `competencia` int(3) NULL COMMENT 'Competencia',
  `calificacion_numero` int(3) NULL COMMENT 'Calificación Número',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `eliminado_por` int(3) DEFAULT '0' COMMENT 'Eliminado Por',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


ALTER TABLE `calificacion_calificaciones`
  ADD PRIMARY KEY (`id`),
  ADD KEY `calificacion` (`calificacion`),
  ADD KEY `docente` (`docente`),
  ADD KEY `estudiante` (`estudiante`),
  ADD KEY `asignatura` (`asignatura`),
  ADD KEY `grupo` (`grupo`),
  ADD KEY `periodo` (`periodo`),
  ADD KEY `competencia` (`competencia`);


ALTER TABLE `calificacion_calificaciones`
  MODIFY `id` int(5) NOT NULL AUTO_INCREMENT COMMENT 'Id';


ALTER TABLE `calificacion_calificaciones`
  ADD CONSTRAINT `calificacion_calificaciones_ibfk_1` FOREIGN KEY (`asignatura`) REFERENCES `asignatura` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `calificacion_calificaciones_ibfk_2` FOREIGN KEY (`grupo`) REFERENCES `grupo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `calificacion_calificaciones_ibfk_3` FOREIGN KEY (`estudiante`) REFERENCES `tercero` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `calificacion_calificaciones_ibfk_4` FOREIGN KEY (`docente`) REFERENCES `tercero` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `calificacion_calificaciones_ibfk_5` FOREIGN KEY (`periodo`) REFERENCES `periodo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `calificacion_calificaciones_ibfk_6` FOREIGN KEY (`competencia`) REFERENCES `competencia` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `calificacion_calificaciones_ibfk_7` FOREIGN KEY (`calificacion`) REFERENCES `calificacion` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;













CREATE TABLE `calificacion_observaciones_generales` (
  `id` int(5) NOT NULL COMMENT 'Id',
  `calificacion` int(5) NOT NULL COMMENT 'Calificación Id',
  `observacion` int(3) NOT NULL COMMENT 'Observación',
  `docente` int(3) NOT NULL COMMENT 'Docente',
  `estudiante` int(3) NOT NULL COMMENT 'Estudiante',
  `grupo` int(3) NOT NULL COMMENT 'Grupo',
  `asignatura` int(3) NOT NULL COMMENT 'Asignatura',
  `periodo` int(1) NOT NULL COMMENT 'Periodo',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `eliminado_por` int(3) DEFAULT '0' COMMENT 'Eliminado Por',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


ALTER TABLE `calificacion_observaciones_generales`
  ADD PRIMARY KEY (`id`),
  ADD KEY `calificacion` (`calificacion`),
  ADD KEY `docente` (`docente`),
  ADD KEY `estudiante` (`estudiante`),
  ADD KEY `asignatura` (`asignatura`),
  ADD KEY `grupo` (`grupo`),
  ADD KEY `periodo` (`periodo`),
  ADD KEY `observacion` (`observacion`);

ALTER TABLE `calificacion_observaciones_generales`
  MODIFY `id` int(5) NOT NULL AUTO_INCREMENT COMMENT 'Id';


ALTER TABLE `calificacion_observaciones_generales`
  ADD CONSTRAINT `calificacion_observaciones_generales_ibfk_1` FOREIGN KEY (`asignatura`) REFERENCES `asignatura` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  
  ADD CONSTRAINT `calificacion_observaciones_generales_ibfk_2` FOREIGN KEY (`grupo`) REFERENCES `grupo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  
  ADD CONSTRAINT `calificacion_observaciones_generales_ibfk_3` FOREIGN KEY (`estudiante`) REFERENCES `tercero` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  
  ADD CONSTRAINT `calificacion_observaciones_generales_ibfk_4` FOREIGN KEY (`docente`) REFERENCES `tercero` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  
  ADD CONSTRAINT `calificacion_observaciones_generales_ibfk_5` FOREIGN KEY (`periodo`) REFERENCES `periodo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  
  ADD CONSTRAINT `calificacion_observaciones_generales_ibfk_6` FOREIGN KEY (`observacion`) REFERENCES `observacion_general` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  
  ADD CONSTRAINT `calificacion_observaciones_generales_ibfk_7` FOREIGN KEY (`calificacion`) REFERENCES `calificacion` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;






-----------------------------------



CREATE TABLE `calificacion_frd` (
  `id` int(5) NOT NULL COMMENT 'Id',
  `calificacion` int(5) NOT NULL COMMENT 'Calificación Id',
  `frd` int(3) NOT NULL COMMENT 'FRD',
  `docente` int(3) NOT NULL COMMENT 'Docente',
  `estudiante` int(3) NOT NULL COMMENT 'Estudiante',
  `grupo` int(3) NOT NULL COMMENT 'Grupo',
  `asignatura` int(3) NOT NULL COMMENT 'Asignatura',
  `periodo` int(1) NOT NULL COMMENT 'Periodo',
  `competencia` int(3) NULL COMMENT 'Competencia',
  `calificacion_numero` int(3) NULL COMMENT 'Calificación Número',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `eliminado_por` int(3) DEFAULT '0' COMMENT 'Eliminado Por',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


ALTER TABLE `calificacion_frd`
  ADD PRIMARY KEY (`id`),
  ADD KEY `calificacion` (`calificacion`),
  ADD KEY `docente` (`docente`),
  ADD KEY `estudiante` (`estudiante`),
  ADD KEY `asignatura` (`asignatura`),
  ADD KEY `grupo` (`grupo`),
  ADD KEY `periodo` (`periodo`),
  ADD KEY `competencia` (`competencia`),
  ADD KEY `frd` (`frd`);


ALTER TABLE `calificacion_frd`
  MODIFY `id` int(5) NOT NULL AUTO_INCREMENT COMMENT 'Id';


ALTER TABLE `calificacion_frd`
  ADD CONSTRAINT `calificacion_frd_ibfk_1` FOREIGN KEY (`asignatura`) REFERENCES `asignatura` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `calificacion_frd_ibfk_2` FOREIGN KEY (`grupo`) REFERENCES `grupo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `calificacion_frd_ibfk_3` FOREIGN KEY (`estudiante`) REFERENCES `tercero` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `calificacion_frd_ibfk_4` FOREIGN KEY (`docente`) REFERENCES `tercero` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `calificacion_frd_ibfk_5` FOREIGN KEY (`periodo`) REFERENCES `periodo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `calificacion_frd_ibfk_6` FOREIGN KEY (`competencia`) REFERENCES `competencia` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `calificacion_frd_ibfk_7` FOREIGN KEY (`calificacion`) REFERENCES `calificacion` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `calificacion_frd_ibfk_8` FOREIGN KEY (`frd`) REFERENCES `frd` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

